// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/ui/webui/omnibox/omnibox.mojom
//

package org.chromium.mojom;

public final class AutocompleteMatchMojo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 104;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(104, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String providerName;
    public boolean providerDone;
    public int relevance;
    public boolean deletable;
    public String fillIntoEdit;
    public String inlineAutocompletion;
    public String destinationUrl;
    public String contents;
    public String description;
    public int transition;
    public boolean allowedToBeDefaultMatch;
    public String type;
    public String associatedKeyword;
    public String keyword;
    public boolean starred;
    public int duplicates;
    public boolean fromPrevious;
    public AutocompleteAdditionalInfo[] additionalInfo;

    private AutocompleteMatchMojo(int version) {
        super(STRUCT_SIZE, version);
    }

    public AutocompleteMatchMojo() {
        this(0);
    }

    public static AutocompleteMatchMojo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static AutocompleteMatchMojo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        AutocompleteMatchMojo result = new AutocompleteMatchMojo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.providerName = decoder0.readString(8, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.providerDone = decoder0.readBoolean(16, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.deletable = decoder0.readBoolean(16, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.allowedToBeDefaultMatch = decoder0.readBoolean(16, 2);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.starred = decoder0.readBoolean(16, 3);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.fromPrevious = decoder0.readBoolean(16, 4);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.relevance = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.fillIntoEdit = decoder0.readString(24, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.inlineAutocompletion = decoder0.readString(32, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.destinationUrl = decoder0.readString(40, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.contents = decoder0.readString(48, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.description = decoder0.readString(56, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.transition = decoder0.readInt(64);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.duplicates = decoder0.readInt(68);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.type = decoder0.readString(72, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.associatedKeyword = decoder0.readString(80, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.keyword = decoder0.readString(88, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(96, false);
            {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.additionalInfo = new AutocompleteAdditionalInfo[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    result.additionalInfo[i1] = AutocompleteAdditionalInfo.decode(decoder2);
                }
            }
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(providerName, 8, true);
        encoder0.encode(providerDone, 16, 0);
        encoder0.encode(deletable, 16, 1);
        encoder0.encode(allowedToBeDefaultMatch, 16, 2);
        encoder0.encode(starred, 16, 3);
        encoder0.encode(fromPrevious, 16, 4);
        encoder0.encode(relevance, 20);
        encoder0.encode(fillIntoEdit, 24, false);
        encoder0.encode(inlineAutocompletion, 32, false);
        encoder0.encode(destinationUrl, 40, false);
        encoder0.encode(contents, 48, false);
        encoder0.encode(description, 56, false);
        encoder0.encode(transition, 64);
        encoder0.encode(duplicates, 68);
        encoder0.encode(type, 72, false);
        encoder0.encode(associatedKeyword, 80, true);
        encoder0.encode(keyword, 88, false);
        if (additionalInfo == null) {
            encoder0.encodeNullPointer(96, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(additionalInfo.length, 96, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < additionalInfo.length; ++i0) {
                encoder1.encode(additionalInfo[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        AutocompleteMatchMojo other = (AutocompleteMatchMojo) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.providerName, other.providerName))
            return false;
        if (this.providerDone != other.providerDone)
            return false;
        if (this.relevance != other.relevance)
            return false;
        if (this.deletable != other.deletable)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.fillIntoEdit, other.fillIntoEdit))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.inlineAutocompletion, other.inlineAutocompletion))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.destinationUrl, other.destinationUrl))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.contents, other.contents))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.description, other.description))
            return false;
        if (this.transition != other.transition)
            return false;
        if (this.allowedToBeDefaultMatch != other.allowedToBeDefaultMatch)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.type, other.type))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.associatedKeyword, other.associatedKeyword))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.keyword, other.keyword))
            return false;
        if (this.starred != other.starred)
            return false;
        if (this.duplicates != other.duplicates)
            return false;
        if (this.fromPrevious != other.fromPrevious)
            return false;
        if (!java.util.Arrays.deepEquals(this.additionalInfo, other.additionalInfo))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(providerName);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(providerDone);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(relevance);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(deletable);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fillIntoEdit);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(inlineAutocompletion);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(destinationUrl);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(contents);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(description);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(transition);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(allowedToBeDefaultMatch);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(type);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(associatedKeyword);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(keyword);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(starred);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(duplicates);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fromPrevious);
        result = prime * result + java.util.Arrays.deepHashCode(additionalInfo);
        return result;
    }
}

